/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.engine;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DbnToVbo {
    private static final int DATA_PACKET_SIZE = 33;

    public static void convert(String dbnFilePath, String vboFilePath) {
        DecimalFormat satsFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        satsFormat.applyPattern("000");
        DecimalFormat coordinatesFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        coordinatesFormat.applyPattern("00000.00000000");
        DecimalFormat commonDecimalFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        commonDecimalFormat.applyPattern("0000.0000");
        String fileTag = String.format("File created on %s", new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()));
        try (FileInputStream dbnStream = new FileInputStream(dbnFilePath);
             FileWriter writer = new FileWriter(vboFilePath);
             BufferedWriter vboWriter = new BufferedWriter(writer);){
            vboWriter.write(fileTag + "\n\n[header]\nsatellites\ntime\nlatitude\nlongitude\nvelocity kmh\nheading\nheight\nYAW__\nYAW_\nYAW\nSLIP\n\n[comments]\nConverted from .dbn file\n[column names]\nsats time lat long velocity heading height YAW__ YAW_ YAW SLIP\n[data]\n");
            do {
                if (((InputStream)dbnStream).read() != 91 || ((InputStream)dbnStream).read() != 68 || ((InputStream)dbnStream).read() != 65 || ((InputStream)dbnStream).read() != 84 || ((InputStream)dbnStream).read() != 65 || ((InputStream)dbnStream).read() != 93) continue;
                ((InputStream)dbnStream).read();
                ((InputStream)dbnStream).read();
                ((InputStream)dbnStream).read();
                break;
            } while (((InputStream)dbnStream).available() >= 6);
            byte[] dataPacketBytes = new byte[33];
            while (((InputStream)dbnStream).read(dataPacketBytes) == 33) {
                int checksumCalc;
                byte sats = dataPacketBytes[0];
                int time = DbnToVbo.convertThreeBytesToUnsingedInt(dataPacketBytes[3], dataPacketBytes[2], dataPacketBytes[1]) * 10;
                double latitude = (double)DbnToVbo.convertFourBytesToUnsingedInt(dataPacketBytes[7], dataPacketBytes[6], dataPacketBytes[5], dataPacketBytes[4]) / 100000.0;
                double longitude = -((double)DbnToVbo.convertFourBytesToUnsingedInt(dataPacketBytes[11], dataPacketBytes[10], dataPacketBytes[9], dataPacketBytes[8]) / 100000.0);
                double velocity = (double)DbnToVbo.convertTwoBytesToUnsignedInt(dataPacketBytes[13], dataPacketBytes[12]) / 100.0;
                double heading = (double)DbnToVbo.convertTwoBytesToUnsignedInt(dataPacketBytes[15], dataPacketBytes[14]) / 100.0;
                double height = (double)DbnToVbo.convertFourBytesToUnsingedInt(dataPacketBytes[19], dataPacketBytes[18], dataPacketBytes[17], dataPacketBytes[16]) / 100.0;
                double yaw__ = (double)DbnToVbo.convertTwoBytesToSignedInt(dataPacketBytes[21], dataPacketBytes[20]) / 10.0;
                double yaw_ = (double)DbnToVbo.convertTwoBytesToSignedInt(dataPacketBytes[23], dataPacketBytes[22]) / 10.0;
                double yaw = (double)DbnToVbo.convertTwoBytesToSignedInt(dataPacketBytes[25], dataPacketBytes[24]) / 10.0;
                double slip = (double)DbnToVbo.convertTwoBytesToSignedInt(dataPacketBytes[27], dataPacketBytes[26]) / 10.0;
                int checksum = DbnToVbo.convertTwoBytesToUnsignedInt(dataPacketBytes[29], dataPacketBytes[28]);
                if (checksum != (checksumCalc = DbnToVbo.calculateDbnChecksum(dataPacketBytes, 28))) {
                    throw new RuntimeException();
                }
                vboWriter.write(String.format("%s %s %s %s %s %s %s %s  %s %s %s\n", satsFormat.format(sats), DbnToVbo.millisToVboTime(time), coordinatesFormat.format(latitude), coordinatesFormat.format(longitude), commonDecimalFormat.format(velocity), commonDecimalFormat.format(heading), commonDecimalFormat.format(height), commonDecimalFormat.format(yaw__), commonDecimalFormat.format(yaw_), commonDecimalFormat.format(yaw), commonDecimalFormat.format(slip)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int calculateDbnChecksum(byte[] data, int length) {
        int crc = 0;
        for (int i = 0; i < length; ++i) {
            crc ^= data[i] * 256;
            crc %= 65536;
            for (int j = 8; j > 0; --j) {
                if ((crc & 0x8000) == 32768) {
                    crc *= 2;
                    crc ^= 0x1024;
                } else {
                    crc *= 2;
                }
                crc %= 65536;
            }
        }
        return crc & 0xFFFF;
    }

    private static String millisToVboTime(int millis) {
        int hour = millis / 3600000;
        int minute = (millis - hour * 1000 * 60 * 60) / 60000;
        int second = (millis - hour * 1000 * 60 * 60 - minute * 1000 * 60) / 1000;
        int secondDecimal = millis - hour * 1000 * 60 * 60 - minute * 1000 * 60 - second * 1000;
        return String.format("%02d%02d%02d.%03d", hour, minute, second, secondDecimal);
    }

    private static int convertFourBytesToUnsingedInt(byte b1, byte b2, byte b3, byte b4) {
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    private static int convertThreeBytesToUnsingedInt(byte b1, byte b2, byte b3) {
        return (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    private static int convertTwoBytesToUnsignedInt(byte b1, byte b2) {
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    private static int convertTwoBytesToSignedInt(byte b1, byte b2) {
        return b2 << 8 | b1;
    }
}

