/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.engine;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.sikrip.vboeditor.engine.VboIOUtils;
import org.sikrip.vboeditor.engine.VboUtils;
import org.sikrip.vboeditor.model.TraveledRouteCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VboEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VboEditor.class);
    private static final String VIDEO_FILE_SUFFIX = "0001";
    private static final String NO_VIDEO_SYNCH_TIME = "-00000001";
    private static final String FINAL_VBO_FILE_SUFFIX = "Data.vbo";
    private static final String AVI_SECTION = "[avi]";

    private VboEditor() {
    }

    public static List<TraveledRouteCoordinate> getTraveledRoute(String vboFilePath) throws IOException {
        Map<String, List<String>> vboSections = VboIOUtils.readVboSections(vboFilePath);
        String dataSeparator = VboUtils.getDataSeparator(vboSections);
        if (Strings.isNullOrEmpty(dataSeparator)) {
            throw new IllegalArgumentException("Cannot determine data separator (check vbo file for corruption)");
        }
        int gpsDataInterval = VboUtils.getGpsDataInterval(vboSections, dataSeparator);
        List<String> header = vboSections.get("[header]");
        int timeIdx = header.indexOf("time");
        int satellitesIdx = header.indexOf("satellites");
        int latitudeIdx = header.indexOf("latitude");
        int longitudeIdx = header.indexOf("longitude");
        int speedIdx = header.indexOf("velocity kmh");
        ArrayList<TraveledRouteCoordinate> coordinates = new ArrayList<TraveledRouteCoordinate>();
        for (String dataLine : vboSections.get("[data]")) {
            String[] data = dataLine.split(dataSeparator);
            Double latitude = Double.valueOf(data[latitudeIdx]);
            Double longitude = Double.valueOf(data[longitudeIdx]);
            if (Integer.valueOf(data[satellitesIdx]) <= 0 || latitude == 0.0 || longitude == 0.0) continue;
            long time = VboUtils.convertToMillis(data[timeIdx]);
            Double speed = Double.valueOf(data[speedIdx]);
            coordinates.add(new TraveledRouteCoordinate(latitude, longitude, time, speed, gpsDataInterval));
        }
        return coordinates;
    }

    public static void createVideoFile(String outputDirBasePath, String originalVideoPath, String sessionName) throws IOException {
        if (!VboEditor.createOutputDirectory(outputDirBasePath + "/" + sessionName)) {
            throw new RuntimeException("Could not create output directory");
        }
        String videoExtension = originalVideoPath.substring(originalVideoPath.lastIndexOf(46));
        File sourceVideo = new File(originalVideoPath);
        File finalVideo = new File(outputDirBasePath + "/" + sessionName + "/" + sessionName + VIDEO_FILE_SUFFIX + videoExtension);
        FileUtils.copyFile(sourceVideo, finalVideo);
    }

    public static void createVboWithVideoMetadata(String outputDirBasePath, String originalVboPath, VideoType videoType, String sessionName, int gpsDataOffset) throws IOException {
        String initialData;
        int logLine;
        Map<String, List<String>> vboSections = VboIOUtils.readVboSections(originalVboPath);
        List<String> headerData = vboSections.get("[header]");
        int aviIndexPosition = headerData.indexOf("avifileindex");
        if (aviIndexPosition > -1) {
            LOGGER.warn("Source vbo file already contains AVIFILEINDEX information. AVIFILEINDEX data will be replaced in the new file.");
        } else {
            headerData.add("avifileindex");
        }
        int aviSyncPosition = headerData.indexOf("avisynctime");
        if (aviSyncPosition > -1) {
            LOGGER.warn("Source vbo file already contains AVISYNCTIME information. AVISYNCTIME data will be replaced in the new file.");
        } else {
            headerData.add("avisynctime");
        }
        String dataSeparator = VboUtils.getDataSeparator(vboSections);
        if (Strings.isNullOrEmpty(dataSeparator)) {
            throw new RuntimeException(String.format("Could not find data separator. Supported separators are %s", VboUtils.DATA_SEPARATORS));
        }
        List<String> columnNamesSection = vboSections.get("[column names]");
        if (columnNamesSection != null && !columnNamesSection.isEmpty()) {
            String columnNames = columnNamesSection.get(0).replaceAll("avifileindex", "").replaceAll("avisynctime", "").trim();
            columnNamesSection.set(0, columnNames + dataSeparator + "avifileindex" + dataSeparator + "avisynctime");
        }
        vboSections.put(AVI_SECTION, Lists.newArrayList(sessionName, videoType.name()));
        List<String> dataLines = VboUtils.getDataLines(vboSections, dataSeparator, aviIndexPosition, aviSyncPosition);
        int gpsDataInterval = VboUtils.getGpsDataInterval(vboSections, dataSeparator);
        int numberOfInvalidLogLines = 0;
        int firstValidOffset = 0;
        if (gpsDataOffset < 0) {
            numberOfInvalidLogLines = Math.abs(gpsDataOffset) / gpsDataInterval;
            firstValidOffset = Math.abs(gpsDataOffset) % gpsDataInterval;
            for (logLine = 0; logLine < numberOfInvalidLogLines; ++logLine) {
                initialData = dataLines.get(logLine);
                String finalData = initialData + dataSeparator + VIDEO_FILE_SUFFIX + dataSeparator + NO_VIDEO_SYNCH_TIME;
                dataLines.set(logLine, finalData);
            }
        }
        while (logLine < dataLines.size()) {
            initialData = dataLines.get(logLine);
            int logLineOffsetMS = gpsDataOffset < 0 ? firstValidOffset + (logLine - numberOfInvalidLogLines) * gpsDataInterval : gpsDataOffset + logLine * gpsDataInterval;
            String finalData = String.format(initialData + dataSeparator + VIDEO_FILE_SUFFIX + dataSeparator + "%1$08d", logLineOffsetMS);
            dataLines.set(logLine, finalData);
            ++logLine;
        }
        vboSections.put("[data]", dataLines);
        if (VboEditor.createOutputDirectory(outputDirBasePath + "/" + sessionName)) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputDirBasePath + "/" + sessionName + "/" + sessionName + FINAL_VBO_FILE_SUFFIX));){
                writer.write(String.format("File created on %s using VBO Editor", new Date()));
                writer.newLine();
                VboIOUtils.writeSection(vboSections, writer, "[header]");
                VboIOUtils.writeSection(vboSections, writer, "[comments]");
                VboIOUtils.writeSection(vboSections, writer, "[channel units]");
                VboIOUtils.writeSection(vboSections, writer, "[session data]");
                VboIOUtils.writeSection(vboSections, writer, "[laptiming]");
                VboIOUtils.writeSection(vboSections, writer, AVI_SECTION);
                VboIOUtils.writeSection(vboSections, writer, "[column names]");
                VboIOUtils.writeSection(vboSections, writer, "[data]");
            }
        } else {
            throw new RuntimeException("Cannot create output directory");
        }
    }

    private static boolean createOutputDirectory(String path) {
        File outDir = new File(path);
        return outDir.exists() || outDir.mkdir();
    }

    public static enum VideoType {
        MP4,
        AVI;

    }
}

