/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.engine;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class VboIOUtils {
    private VboIOUtils() {
    }

    static Map<String, List<String>> readVboSections(String vboFilePath) throws IOException {
        try (FileInputStream vboFileStream = new FileInputStream(new File(vboFilePath));){
            BufferedReader vboReader = new BufferedReader(new InputStreamReader(vboFileStream));
            HashMap<String, List<String>> vboFileSections = new HashMap<String, List<String>>();
            VboIOUtils.readAllSections(vboReader, null, vboFileSections);
            HashMap<String, List<String>> hashMap = vboFileSections;
            return hashMap;
        }
    }

    static void writeSection(Map<String, List<String>> vboSections, BufferedWriter writer, String sectionName) throws IOException {
        if (vboSections.containsKey(sectionName)) {
            writer.write(sectionName);
            writer.newLine();
            for (String sectionEntry : vboSections.get(sectionName)) {
                writer.write(sectionEntry);
                writer.newLine();
            }
            writer.newLine();
        }
    }

    private static void readAllSections(BufferedReader vboReader, String sectionName, Map<String, List<String>> vboFileSections) throws IOException {
        String vboLine;
        ArrayList<String> sectionData = new ArrayList<String>();
        while ((vboLine = vboReader.readLine()) != null) {
            if (vboLine.startsWith("[")) {
                VboIOUtils.readAllSections(vboReader, vboLine, vboFileSections);
                continue;
            }
            if (Strings.isNullOrEmpty(sectionName) || Strings.isNullOrEmpty(vboLine)) continue;
            sectionData.add(vboLine);
        }
        if (!Strings.isNullOrEmpty(sectionName)) {
            vboFileSections.put(sectionName, sectionData);
        }
    }
}

