/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.engine;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.sikrip.vboeditor.engine.DbnToVbo;

public class VboToDbn {
    private static final byte[] NEW_LINE_BYTES = new byte[]{13, 10};
    private static final byte[] NEW_DATA_LINE_BYTES = new byte[]{13, 10, 36};
    private static final byte ZERO = 0;

    public static void convert(String vboFilePath, String dbnFilePath) {
        try (BufferedReader vboReader = new BufferedReader(new FileReader(vboFilePath));
             FileOutputStream dbnWriter = new FileOutputStream(dbnFilePath);){
            String inputLine;
            while (!(inputLine = vboReader.readLine()).startsWith("File created")) {
            }
            dbnWriter.write(inputLine.getBytes(StandardCharsets.UTF_8));
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("[HEADER]".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("SATS(1)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("TIME(3)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("LATITUDE(4)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("LONGITUDE(4)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("VELOCITY(2)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("HEADING(2)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("HEIGHT(4)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("YAW__(2)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("YAW_(2)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("YAW(2)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("SLIP(2)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("CHKSUM(2)".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("[COMMENTS]".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("Converted using vbotools".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("Find more on www.vbotools.com".getBytes());
            dbnWriter.write(NEW_LINE_BYTES);
            dbnWriter.write("[DATA]".getBytes());
            dbnWriter.write(NEW_DATA_LINE_BYTES);
            while (!(inputLine = vboReader.readLine()).equalsIgnoreCase("[header]")) {
            }
            ArrayList<String> headerNames = new ArrayList<String>();
            while (!(inputLine = vboReader.readLine()).startsWith("[")) {
                if ("".equals(inputLine)) continue;
                headerNames.add(inputLine.toLowerCase());
            }
            int satsIdx = headerNames.indexOf("satellites");
            int timeIdx = headerNames.indexOf("time");
            int latIdx = headerNames.indexOf("latitude");
            int longIdx = headerNames.indexOf("longitude");
            int velocityIdx = headerNames.indexOf("velocity kmh");
            int headingIdx = headerNames.indexOf("heading");
            int heightIdx = headerNames.indexOf("height");
            while (!(inputLine = vboReader.readLine()).equalsIgnoreCase("[data]")) {
            }
            while ((inputLine = vboReader.readLine()) != null) {
                String[] inputDataArray = inputLine.replaceAll(",", ".").split(" ");
                byte[] payload = new byte[28];
                int payloadIdx = 0;
                payload[payloadIdx++] = Byte.parseByte(inputDataArray[satsIdx]);
                int time = (int)(VboToDbn.vboTimeToMillis(inputDataArray[timeIdx]) / 10L);
                byte[] timeBytes = VboToDbn.intToByteArray(time);
                payload[payloadIdx++] = timeBytes[1];
                payload[payloadIdx++] = timeBytes[2];
                payload[payloadIdx++] = timeBytes[3];
                int lat = BigDecimal.valueOf(Double.parseDouble(inputDataArray[latIdx])).multiply(BigDecimal.valueOf(100000L)).intValue();
                byte[] latBytes = VboToDbn.intToByteArray(lat);
                payload[payloadIdx++] = latBytes[0];
                payload[payloadIdx++] = latBytes[1];
                payload[payloadIdx++] = latBytes[2];
                payload[payloadIdx++] = latBytes[3];
                int longitude = -BigDecimal.valueOf(Double.parseDouble(inputDataArray[longIdx])).multiply(BigDecimal.valueOf(100000L)).intValue();
                byte[] longBytes = VboToDbn.intToByteArray(longitude);
                payload[payloadIdx++] = longBytes[0];
                payload[payloadIdx++] = longBytes[1];
                payload[payloadIdx++] = longBytes[2];
                payload[payloadIdx++] = longBytes[3];
                int velocity = BigDecimal.valueOf(Double.parseDouble(inputDataArray[velocityIdx])).multiply(BigDecimal.valueOf(100L)).intValue();
                byte[] velocityBytes = VboToDbn.intToByteArray(velocity);
                payload[payloadIdx++] = velocityBytes[2];
                payload[payloadIdx++] = velocityBytes[3];
                int heading = BigDecimal.valueOf(Double.parseDouble(inputDataArray[headingIdx])).multiply(BigDecimal.valueOf(100L)).intValue();
                byte[] headingBytes = VboToDbn.intToByteArray(heading);
                payload[payloadIdx++] = headingBytes[2];
                payload[payloadIdx++] = headingBytes[3];
                int height = BigDecimal.valueOf(Double.parseDouble(inputDataArray[heightIdx])).multiply(BigDecimal.valueOf(100L)).intValue();
                byte[] heightBytes = VboToDbn.intToByteArray(height);
                payload[payloadIdx++] = heightBytes[0];
                payload[payloadIdx++] = heightBytes[1];
                payload[payloadIdx++] = heightBytes[2];
                payload[payloadIdx++] = heightBytes[3];
                payload[payloadIdx++] = 0;
                payload[payloadIdx++] = 0;
                payload[payloadIdx++] = 0;
                payload[payloadIdx++] = 0;
                payload[payloadIdx++] = 0;
                payload[payloadIdx++] = 0;
                payload[payloadIdx++] = 0;
                payload[payloadIdx++] = 0;
                if (payloadIdx != 28) {
                    throw new RuntimeException("Not entire payload written");
                }
                dbnWriter.write(payload);
                int checksum = DbnToVbo.calculateDbnChecksum(payload, 28);
                byte[] checksumBytes = VboToDbn.intToByteArray(checksum);
                dbnWriter.write(checksumBytes[2]);
                dbnWriter.write(checksumBytes[3]);
                dbnWriter.write(NEW_DATA_LINE_BYTES);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    private static long vboTimeToMillis(String time) {
        int length = time.length();
        if (length == 10 || length == 9) {
            long hh = Long.parseLong(time.substring(0, 2));
            long mm = Long.parseLong(time.substring(2, 4));
            long ss = Long.parseLong(time.substring(4, 6));
            long millis = length == 9 ? Long.parseLong(time.substring(7, length)) * 10L : Long.parseLong(time.substring(7, length));
            return millis + ss * 1000L + mm * 60L * 1000L + hh * 60L * 60L * 1000L;
        }
        throw new IllegalArgumentException(String.format("Unexpected VBO time value %s", time));
    }
}

