/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class VboUtils {
    static final String HEADER_SECTION = "[header]";
    static final String COLUMN_NAMES_SECTION = "[column names]";
    static final String DATA_SECTION = "[data]";
    static final String[] DATA_SEPARATORS = new String[]{" ", ",", "\t"};
    static final String AVIFILEINDEX = "avifileindex";
    static final String AVISYNCTIME = "avisynctime";

    private VboUtils() {
    }

    static String getDataSeparator(Map<String, List<String>> vboSections) {
        String dataLine = vboSections.get(DATA_SECTION).get(0);
        for (String separator : DATA_SEPARATORS) {
            if (dataLine.split(separator).length <= 0) continue;
            return separator;
        }
        return null;
    }

    static long convertToMillis(String time) {
        if (time.length() != 9 && time.length() != 10) {
            throw new IllegalArgumentException(String.format("Unexpected VBO time value %s", time));
        }
        long hh = Long.parseLong(time.substring(0, 2));
        long mm = Long.parseLong(time.substring(2, 4));
        long ss = Long.parseLong(time.substring(4, 6));
        long millis = time.length() == 9 ? Long.parseLong(time.substring(7, 9)) * 10L : Long.parseLong(time.substring(7, 10));
        return millis + ss * 1000L + mm * 60L * 1000L + hh * 60L * 60L * 1000L;
    }

    static int getGpsDataInterval(Map<String, List<String>> vboFileSections, String dataSeparator) {
        int numberOfSamples = 10;
        int entriesToSkip = 10;
        if (vboFileSections.get(DATA_SECTION).size() < 20) {
            throw new IllegalArgumentException("Data sample to small");
        }
        int timeColumnIdx = vboFileSections.get(HEADER_SECTION).indexOf("time");
        long time = -1L;
        long sumOfIntervals = 0L;
        for (int i = 10; i < 20; ++i) {
            long currentTime = VboUtils.convertToMillis(vboFileSections.get(DATA_SECTION).get(i).split(dataSeparator)[timeColumnIdx]);
            if (time != -1L) {
                sumOfIntervals += currentTime - time;
            }
            time = currentTime;
        }
        long intervalMillis = sumOfIntervals / 9L;
        int[] intervals = new int[]{1000, 200, 100, 50};
        long[] diffsPerInterval = new long[]{Math.abs(1000L - intervalMillis), Math.abs(200L - intervalMillis), Math.abs(100L - intervalMillis), Math.abs(50L - intervalMillis)};
        long minDiff = diffsPerInterval[0];
        int minDiffIdx = 0;
        for (int i = 1; i < diffsPerInterval.length; ++i) {
            if (diffsPerInterval[i] >= minDiff) continue;
            minDiff = diffsPerInterval[i];
            minDiffIdx = i;
        }
        return intervals[minDiffIdx];
    }

    static List<String> getDataLines(Map<String, List<String>> vboSections, String separator, int aviIndexPosition, int aviSyncPosition) {
        ArrayList<String> dataLinesNoVideoData = new ArrayList<String>();
        for (String line : vboSections.get(DATA_SECTION)) {
            StringBuilder lineBuilder = new StringBuilder();
            String[] dataArray = line.split(separator);
            for (int i = 0; i < dataArray.length; ++i) {
                if (i == aviIndexPosition || i == aviSyncPosition) continue;
                lineBuilder.append(dataArray[i]).append(separator);
            }
            dataLinesNoVideoData.add(lineBuilder.toString().trim());
        }
        return dataLinesNoVideoData;
    }

    static List<Double> getAccelerationData(List<String> data, String separator, int timeDataIdx, int velocityDataIdx) {
        ArrayList<Double> accelerationData = new ArrayList<Double>();
        accelerationData.add(0.0);
        for (int i = 0; i < data.size() - 1; ++i) {
            String[] currentData = data.get(i).split(separator);
            String[] nextData = data.get(i + 1).split(separator);
            double velocity = Double.valueOf(currentData[velocityDataIdx]);
            double nextVelocity = Double.valueOf(nextData[velocityDataIdx]);
            long time = VboUtils.convertToMillis(currentData[timeDataIdx]);
            long nextTime = VboUtils.convertToMillis(nextData[timeDataIdx]);
            double acceleration = (nextVelocity - velocity) / (double)(nextTime - time);
            accelerationData.add(acceleration);
        }
        return accelerationData;
    }

    static List<Double> getBrakeChannel(List<Double> accelerationData, double maxBrake) {
        ArrayList<Double> brakeChannel = new ArrayList<Double>();
        for (Double acceleration : accelerationData) {
            if (acceleration < 0.0) {
                brakeChannel.add(maxBrake / acceleration * 100.0);
                continue;
            }
            brakeChannel.add(0.0);
        }
        return brakeChannel;
    }
}

