/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.gui;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sikrip.vboeditor.engine.DbnToVbo;
import org.sikrip.vboeditor.gui.FileConverterPanelSupport;
import org.sikrip.vboeditor.gui.VboEditorApplication;
import org.sikrip.vboeditor.helper.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbnToVboConverterPanel
extends FileConverterPanelSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbnToVboConverterPanel.class);

    public DbnToVboConverterPanel(VboEditorApplication editor) {
        super(editor);
    }

    @Override
    String getConvertButtonText() {
        return "Convert to dbn";
    }

    @Override
    void doConvert() {
        try {
            String outputFilePath = this.getOutFileFolderPath() + "/" + new File(this.getInputFilePath()).getName() + ".vbo";
            DbnToVbo.convert(this.getInputFilePath(), outputFilePath);
            JOptionPane.showMessageDialog(null, "Vbo file: " + outputFilePath, "Conversion completed.", 1);
        }
        catch (Exception e) {
            ErrorHandler.showError("Could not convert", "Unable to perform dbn to vbo conversion.", e);
            LOGGER.error("Unable to perform dbn to vbo conversion", e);
        }
    }

    @Override
    FileFilter getFileNameExtensionFilter() {
        return new FileNameExtensionFilter(".dbn files", "dbn");
    }

    @Override
    String getTitle() {
        return "Convert from .dbn to .vbo";
    }
}

