/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.sikrip.vboeditor.gui.VboEditorApplication;

public abstract class FileConverterPanelSupport
extends JPanel {
    private final VboEditorApplication editor;
    private final JTextField inputFilePath = new JTextField();
    private final JButton inputFileChooseBtn = new JButton("...");
    private final JTextField outFileFolderPath = new JTextField();
    private final JButton convertBtn = new JButton(this.getConvertButtonText());

    public FileConverterPanelSupport(VboEditorApplication editor) {
        this.editor = editor;
        this.createGUI();
        this.addActionListeners();
    }

    public String getInputFilePath() {
        return this.inputFilePath.getText();
    }

    public String getOutFileFolderPath() {
        return this.outFileFolderPath.getText();
    }

    private void createGUI() {
        this.setBorder(BorderFactory.createTitledBorder(this.getTitle()));
        JPanel innerPanel = new JPanel();
        innerPanel.add(new JLabel("Choose input file"));
        innerPanel.add(this.inputFilePath);
        innerPanel.add(this.inputFileChooseBtn);
        this.add(innerPanel);
        innerPanel = new JPanel();
        this.outFileFolderPath.setEditable(false);
        this.outFileFolderPath.setEnabled(false);
        innerPanel.add(new JLabel("Output folder"));
        innerPanel.add(this.outFileFolderPath);
        this.add(innerPanel);
        innerPanel = new JPanel();
        innerPanel.add(this.convertBtn);
        this.add(innerPanel);
        this.inputFilePath.setPreferredSize(new Dimension(300, 30));
        this.outFileFolderPath.setPreferredSize(new Dimension(300, 30));
    }

    private void addActionListeners() {
        this.inputFileChooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileConverterPanelSupport.this.chooseVboFile();
            }
        });
        this.convertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileConverterPanelSupport.this.convert();
            }
        });
    }

    private void chooseVboFile() {
        JFileChooser fileChooser = new JFileChooser();
        if (VboEditorApplication.getBrowsePath() != null) {
            fileChooser.setCurrentDirectory(new File(VboEditorApplication.getBrowsePath()));
        }
        fileChooser.setFileFilter(this.getFileNameExtensionFilter());
        if (fileChooser.showOpenDialog(this) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.inputFilePath.setText(selectedFile.getAbsolutePath());
            this.outFileFolderPath.setText(selectedFile.getParent());
        }
    }

    private void convert() {
        FileConverterPanelSupport messageDialogParent = this;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                FileConverterPanelSupport.this.doConvert();
                return null;
            }

            @Override
            protected void done() {
                FileConverterPanelSupport.this.editor.hideWaitDlg();
            }
        };
        worker.execute();
        this.editor.showWaitDlg();
    }

    abstract String getConvertButtonText();

    abstract FileFilter getFileNameExtensionFilter();

    abstract String getTitle();

    abstract void doConvert();
}

