/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.sikrip.vboeditor.gui.TelemetryPlayer;
import org.sikrip.vboeditor.gui.VboEditorApplication;
import org.sikrip.vboeditor.gui.VideoPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SynchronizationPanel
extends JPanel {
    private final Logger LOGGER = LoggerFactory.getLogger(SynchronizationPanel.class);
    private final VideoPlayer videoPlayer;
    private final TelemetryPlayer telemetryPlayer;
    private InvalidationListener telemetryPlayerListener;
    private long telemetryDataOffset;
    private final VboEditorApplication editor;

    SynchronizationPanel(VboEditorApplication editor) {
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.videoPlayer = new VideoPlayer(this);
        this.telemetryPlayer = new TelemetryPlayer(this);
        JSplitPane splitPane = new JSplitPane(1, this.videoPlayer, this.telemetryPlayer);
        this.add((Component)splitPane, "Center");
        this.videoPlayer.setPreferredSize(new Dimension(450, 300));
        this.telemetryPlayer.setPreferredSize(new Dimension(350, 300));
        this.telemetryPlayerListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                SynchronizationPanel.this.telemetryPlayer.seekByTime(SynchronizationPanel.this.videoPlayer.getCurrentTime() - SynchronizationPanel.this.telemetryDataOffset);
            }
        };
    }

    void requestPause() {
        this.videoPlayer.requestPause();
        this.telemetryPlayer.requestPause();
    }

    void unlock() {
        this.videoPlayer.removePlayListener(this.telemetryPlayerListener);
        this.videoPlayer.enableFileControls(true);
        this.telemetryPlayer.enableFileControls(true);
        this.telemetryPlayer.enableControls(true);
    }

    void lock() {
        this.calculateTelemetryOffset();
        this.videoPlayer.addPlayListener(this.telemetryPlayerListener);
        this.telemetryPlayer.enableControls(false);
        this.videoPlayer.enableFileControls(false);
        this.telemetryPlayer.enableFileControls(false);
    }

    void stepTelemetry(long amount) {
        if (this.editor.isDataLocked()) {
            this.telemetryPlayer.seekByTime(this.videoPlayer.getCurrentTime() - this.telemetryDataOffset + amount);
        }
    }

    void seekTelemetryByTime(long time) {
        if (this.editor.isDataLocked()) {
            this.telemetryPlayer.seekByTime(time - this.telemetryDataOffset);
        }
    }

    void checkCanLock() {
        this.editor.enableDataLock(this.videoPlayer.isLoaded() && this.telemetryPlayer.isLoaded());
    }

    boolean isDataLocked() {
        return this.editor.isDataLocked();
    }

    long getTelemetryDataOffset() {
        return this.telemetryDataOffset;
    }

    String getVideoFilePath() {
        return this.videoPlayer.getFilePath();
    }

    String getTelemetryFilePath() {
        return this.telemetryPlayer.getFilePath();
    }

    private void calculateTelemetryOffset() {
        this.telemetryDataOffset = this.videoPlayer.getCurrentTime() - this.telemetryPlayer.getCurrentTime();
        this.LOGGER.debug("Video time is {}", (Object)this.videoPlayer.getCurrentTime());
        this.LOGGER.debug("Telemetry time is {}", (Object)this.telemetryPlayer.getCurrentTime());
        this.LOGGER.debug("Offset is {}", (Object)this.telemetryDataOffset);
    }
}

