/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sikrip.vboeditor.engine.VboEditor;
import org.sikrip.vboeditor.gui.SynchronizationPanel;
import org.sikrip.vboeditor.gui.VboEditorApplication;
import org.sikrip.vboeditor.helper.ErrorHandler;
import org.sikrip.vboeditor.helper.TimeHelper;
import org.sikrip.vboeditor.model.TraveledRouteCoordinate;
import org.sikrip.vboeditor.model.TraveledRoutePoint;

final class TelemetryPlayer
extends JPanel
implements ActionListener,
ChangeListener {
    private static final int MINIMUM_IMAGE_PADDING_IN_PX = 50;
    private static final int CURRENT_POSITION_MARKER_SIZE = 8;
    private final JButton fileChoose = new JButton("...");
    private final JTextField filePath = new JTextField();
    private final SynchronizationPanel synchronizationPanel;
    private final TraveledRoutePanel traveledRoutePanel;
    private final JPanel controlsPanel = new JPanel(new BorderLayout());
    private final JLabel timeLabel = new JLabel();
    private final JLabel speedLabel = new JLabel();
    private final JButton prev2 = new JButton("<<");
    private final JButton prev = new JButton("<");
    private final JButton next = new JButton(">");
    private final JButton next2 = new JButton(">>");
    private final JButton playPause = new JButton("Play");
    private final JButton reset = new JButton("Reset");
    private final JSlider seekSlider = new JSlider();
    private final AtomicBoolean playFlag = new AtomicBoolean(false);
    private long gpsDataIntervalMillis;
    private int currentPositionIdx = 0;
    private final List<TraveledRoutePoint> traveledRoutePoints = new ArrayList<TraveledRoutePoint>();

    TelemetryPlayer(SynchronizationPanel synchronizationPanel) {
        this.synchronizationPanel = synchronizationPanel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Telemetry (.vbo)"));
        this.add((Component)this.createFileInputPanel(), "North");
        this.traveledRoutePanel = new TraveledRoutePanel();
        this.add((Component)this.traveledRoutePanel, "Center");
        this.createControlsPanel();
        this.add((Component)this.controlsPanel, "South");
        this.enableControls(false);
    }

    private JPanel createFileInputPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.filePath);
        panel.add(this.fileChoose);
        this.fileChoose.setToolTipText("Select a .vbo file that do not contain any video related data.");
        this.fileChoose.addActionListener(this);
        return panel;
    }

    private void createControlsPanel() {
        JPanel buttons = new JPanel();
        buttons.add(this.prev2);
        buttons.add(this.prev);
        buttons.add(this.playPause);
        buttons.add(this.next);
        buttons.add(this.next2);
        buttons.add(this.reset);
        this.prev2.setToolTipText("Two steps back");
        this.prev.setToolTipText("One step back");
        this.next.setToolTipText("One step forward");
        this.next2.setToolTipText("Two steps forward");
        this.reset.setToolTipText("Go to the start");
        JPanel labels = new JPanel(new GridLayout(1, 2));
        labels.add(this.timeLabel);
        labels.add(this.speedLabel);
        this.controlsPanel.add((Component)labels, "North");
        this.controlsPanel.add((Component)this.seekSlider, "Center");
        this.controlsPanel.add((Component)buttons, "South");
        this.prev2.addActionListener(this);
        this.prev.addActionListener(this);
        this.playPause.addActionListener(this);
        this.reset.addActionListener(this);
        this.next.addActionListener(this);
        this.next2.addActionListener(this);
        this.seekSlider.addChangeListener(this);
        this.seekSlider.setValue(0);
    }

    private void paintTraveledRoute() {
        try {
            this.calculateTraveledRoute(VboEditor.getTraveledRoute(this.filePath.getText()));
            this.traveledRoutePanel.repaint();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot draw traveled route", e);
        }
    }

    private void loadTelemetry() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            if (VboEditorApplication.getBrowsePath() != null) {
                fileChooser.setCurrentDirectory(new File(VboEditorApplication.getBrowsePath()));
            }
            fileChooser.setFileFilter(new FileNameExtensionFilter("VBox data files", "vbo"));
            if (fileChooser.showOpenDialog(this) == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.filePath.setText(selectedFile.getAbsolutePath());
                this.paintTraveledRoute();
                this.setupSlider();
                this.enableControls(true);
                this.synchronizationPanel.checkCanLock();
                VboEditorApplication.setBrowsePath(selectedFile.getParent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.showError("Could not load telemetry", "Invalid .vbo file", e);
            this.filePath.setText("");
        }
    }

    private void setupSlider() {
        this.seekSlider.setMinimum(0);
        this.seekSlider.setMaximum(this.traveledRoutePoints.size() - 1);
        this.seekSlider.setValue(0);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("0"));
        long timeMillis = this.traveledRoutePoints.get(this.traveledRoutePoints.size() - 1).getTime();
        labelTable.put(this.seekSlider.getMaximum(), new JLabel(TimeHelper.getTimeString(timeMillis)));
        this.seekSlider.setLabelTable(labelTable);
        this.seekSlider.setPaintLabels(true);
    }

    private void reset() {
        this.playFlag.set(false);
        this.currentPositionIdx = 0;
        this.playPause.setText("Play");
        this.seekSlider.setValue(this.currentPositionIdx);
        this.traveledRoutePanel.repaint();
        this.enableScanControls(true);
    }

    private void enableScanControls(boolean enable) {
        this.prev.setEnabled(enable);
        this.prev2.setEnabled(enable);
        this.next.setEnabled(enable);
        this.next2.setEnabled(enable);
        this.seekSlider.setEnabled(enable);
        this.reset.setEnabled(enable);
    }

    void enableControls(boolean enable) {
        this.enableScanControls(enable);
        this.reset.setEnabled(enable);
        this.playPause.setEnabled(enable);
    }

    private void play() {
        this.playPause.setText("Pause");
        this.enableScanControls(false);
        this.enableFileControls(false);
        this.playFlag.set(true);
        Thread playThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TelemetryPlayer.this.currentPositionIdx < TelemetryPlayer.this.traveledRoutePoints.size() && TelemetryPlayer.this.playFlag.get()) {
                    TelemetryPlayer.this.step(1);
                    try {
                        Thread.sleep(TelemetryPlayer.this.gpsDataIntervalMillis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        playThread.start();
    }

    private void drawPosition() {
        if (this.traveledRoutePoints.isEmpty()) {
            this.timeLabel.setText("");
            this.speedLabel.setText("");
            this.seekSlider.setValue(0);
            this.seekSlider.setVisible(true);
            this.enableControls(false);
            this.traveledRoutePanel.repaint();
        } else {
            long timeMillis = this.traveledRoutePoints.get(this.currentPositionIdx).getTime();
            this.timeLabel.setText("Time: " + TimeHelper.getTimeString(timeMillis));
            this.speedLabel.setText("Speed: " + this.traveledRoutePoints.get(this.currentPositionIdx).getSpeed());
            this.seekSlider.setValue(this.currentPositionIdx);
            this.traveledRoutePanel.repaint();
        }
    }

    private void seekByPosition(int position) {
        this.currentPositionIdx = position;
        if (this.currentPositionIdx < 0) {
            this.currentPositionIdx = 0;
        } else if (this.currentPositionIdx >= this.traveledRoutePoints.size()) {
            this.currentPositionIdx = this.traveledRoutePoints.size() - 1;
        }
        this.drawPosition();
    }

    private void calculateTraveledRoute(List<TraveledRouteCoordinate> traveledRouteCoordinates) {
        if (traveledRouteCoordinates.isEmpty()) {
            throw new RuntimeException("Cannot read travelled route");
        }
        Dimension traveledRouteComponentSize = this.traveledRoutePanel.getSize();
        this.gpsDataIntervalMillis = traveledRouteCoordinates.get(0).getGpsDataInterval();
        this.traveledRoutePoints.clear();
        double actualWidth = traveledRouteComponentSize.getWidth();
        double actualHeight = traveledRouteComponentSize.getHeight();
        Point2D.Double minXY = new Point2D.Double(-1.0, -1.0);
        Point2D.Double maxXY = new Point2D.Double(-1.0, -1.0);
        ArrayList<Point2D.Double> routePoints = new ArrayList<Point2D.Double>();
        for (TraveledRouteCoordinate coordinate : traveledRouteCoordinates) {
            double longitude = coordinate.getLongitude() * Math.PI / 180.0;
            double latitude = coordinate.getLatitude() * Math.PI / 180.0;
            Point2D.Double xy = new Point2D.Double(longitude, latitude);
            minXY.x = minXY.x == -1.0 ? xy.x : Math.min(minXY.x, xy.x);
            minXY.y = minXY.y == -1.0 ? xy.y : Math.min(minXY.y, xy.y);
            routePoints.add(xy);
        }
        for (Point2D.Double point : routePoints) {
            point.x -= minXY.x;
            point.y -= minXY.y;
            maxXY.x = maxXY.x == -1.0 ? point.x : Math.max(maxXY.x, point.x);
            maxXY.y = maxXY.y == -1.0 ? point.y : Math.max(maxXY.y, point.y);
        }
        double paddingBothSides = 100.0;
        double mapWidth = actualWidth - paddingBothSides;
        double mapHeight = actualHeight - paddingBothSides;
        double mapWidthRatio = mapWidth / maxXY.x;
        double mapHeightRatio = mapHeight / maxXY.y;
        double globalRatio = Math.min(mapWidthRatio, mapHeightRatio);
        double heightPadding = (actualHeight - globalRatio * maxXY.y) / 2.0;
        double widthPadding = (actualWidth - globalRatio * maxXY.x) / 2.0;
        for (int i = 0; i < routePoints.size(); ++i) {
            TraveledRouteCoordinate coordinate = traveledRouteCoordinates.get(i);
            Point2D.Double point = (Point2D.Double)routePoints.get(i);
            int adjustedX = (int)(actualWidth - widthPadding - point.getX() * globalRatio);
            int adjustedY = (int)(actualHeight - heightPadding - point.getY() * globalRatio);
            this.traveledRoutePoints.add(new TraveledRoutePoint(adjustedX, adjustedY, (long)i * this.gpsDataIntervalMillis, coordinate.getSpeed()));
        }
    }

    void enableFileControls(boolean b) {
        this.fileChoose.setEnabled(b);
        this.filePath.setEnabled(b);
    }

    long getCurrentTime() {
        return this.traveledRoutePoints.get(this.currentPositionIdx).getTime();
    }

    String getFilePath() {
        return this.filePath.getText();
    }

    private void playPause() {
        if (this.playFlag.get()) {
            this.pause();
        } else {
            this.play();
        }
    }

    void requestPause() {
        this.playFlag.set(false);
    }

    void pause() {
        this.requestPause();
        this.playPause.setText("Play");
        this.enableScanControls(true);
        this.enableFileControls(true);
    }

    private void step(int amount) {
        this.currentPositionIdx += amount;
        if (this.currentPositionIdx < 0) {
            this.currentPositionIdx = 0;
        } else if (this.currentPositionIdx >= this.traveledRoutePoints.size()) {
            this.currentPositionIdx = this.traveledRoutePoints.size() - 1;
        }
        this.drawPosition();
    }

    void seekByTime(long targetTime) {
        int positionGuess = (int)(targetTime / this.gpsDataIntervalMillis);
        if (positionGuess < 0) {
            this.seekByPosition(0);
        } else if (positionGuess >= this.traveledRoutePoints.size()) {
            this.seekByPosition(this.traveledRoutePoints.size() - 1);
        } else {
            long prevNext;
            long prevDiff;
            int position = positionGuess;
            long diff = Math.abs(targetTime - this.traveledRoutePoints.get(positionGuess).getTime());
            if (positionGuess > 0 && (prevDiff = Math.abs(targetTime - this.traveledRoutePoints.get(positionGuess - 1).getTime())) < diff) {
                position = positionGuess - 1;
            }
            if (positionGuess < this.traveledRoutePoints.size() - 1 && (prevNext = Math.abs(targetTime - this.traveledRoutePoints.get(positionGuess + 1).getTime())) < diff) {
                position = positionGuess + 1;
            }
            this.seekByPosition(position);
        }
    }

    boolean isLoaded() {
        return !this.filePath.getText().isEmpty();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.seekByPosition(this.seekSlider.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.prev2) {
            this.step(-2);
        } else if (source == this.prev) {
            this.step(-1);
        } else if (source == this.playPause) {
            this.playPause();
        } else if (source == this.reset) {
            this.reset();
        } else if (source == this.next) {
            this.step(1);
        } else if (source == this.next2) {
            this.step(2);
        } else if (source == this.fileChoose) {
            this.loadTelemetry();
        }
    }

    private class TraveledRoutePanel
    extends JPanel {
        private TraveledRoutePanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!TelemetryPlayer.this.traveledRoutePoints.isEmpty()) {
                Polygon traveledRoute = new Polygon();
                for (TraveledRoutePoint traveledRoutePoint : TelemetryPlayer.this.traveledRoutePoints) {
                    traveledRoute.addPoint(traveledRoutePoint.getX(), traveledRoutePoint.getY());
                }
                g.drawPolygon(traveledRoute);
                g.setColor(Color.red);
                TraveledRoutePoint currentPosition = TelemetryPlayer.this.traveledRoutePoints.get(TelemetryPlayer.this.currentPositionIdx);
                g.fillOval(currentPosition.getX() - 4, currentPosition.getY() - 4, 8, 8);
            }
        }
    }
}

