/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.gui;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.sikrip.vboeditor.engine.VboEditor;
import org.sikrip.vboeditor.gui.FileConverterPanel;
import org.sikrip.vboeditor.gui.SynchronizationPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VboEditorApplication
extends JFrame
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(VboEditorApplication.class);
    private final JTabbedPane tabs = new JTabbedPane();
    private final JPanel telemetryVideoIntegrationPanel = new JPanel(new BorderLayout());
    private final JDialog waitDialog;
    private final SynchronizationPanel synchronizationPanel;
    private final FileConverterPanel fileConverterPanel;
    private final JTextField outputDirPath = new JTextField();
    private final JButton outputDirChoose = new JButton("...");
    private final JTextField sessionName = new JTextField();
    private final JCheckBox syncLock = new JCheckBox("Lock video / telemetry data");
    private final JButton performIntegration = new JButton("Integrate video / telemetry data");
    private static String browsePath = null;

    private VboEditorApplication() throws HeadlessException {
        this.synchronizationPanel = new SynchronizationPanel(this);
        this.fileConverterPanel = new FileConverterPanel(this);
        this.waitDialog = new JDialog((Frame)this, true);
    }

    private void createGui() {
        this.waitDialog.getContentPane().add(new JLabel("<html><h2>Working, please wait...</h2></html>"));
        this.waitDialog.setUndecorated(true);
        this.waitDialog.pack();
        this.waitDialog.setLocationRelativeTo(this);
        this.telemetryVideoIntegrationPanel.setPreferredSize(new Dimension(840, 460));
        this.telemetryVideoIntegrationPanel.add((Component)this.synchronizationPanel, "Center");
        this.telemetryVideoIntegrationPanel.add((Component)this.createSouthPanel(), "South");
        this.tabs.add("Telemetry / video integration", this.telemetryVideoIntegrationPanel);
        this.tabs.add("File conversion", this.fileConverterPanel);
        this.tabs.add("About", this.createAboutPanel());
        this.setTitle("Vbo Tools (0.94beta)");
        this.getContentPane().add(this.tabs);
        this.enableDataLock(false);
    }

    void showWaitDlg() {
        this.waitDialog.setVisible(true);
    }

    void hideWaitDlg() {
        this.waitDialog.dispose();
    }

    private JPanel createSouthPanel() {
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        JLabel label = new JLabel("Output folder: ");
        panel.add(label);
        panel.add(this.outputDirPath);
        panel.add(this.outputDirChoose);
        String toolTipText = "Select a folder to place the result files.";
        label.setToolTipText(toolTipText);
        this.outputDirPath.setToolTipText(toolTipText);
        this.outputDirChoose.setToolTipText(toolTipText);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        label = new JLabel("Session Name: ");
        this.sessionName.setToolTipText(toolTipText);
        panel.add(label);
        panel.add(this.sessionName);
        toolTipText = "<html>Select a name for the session of the .vbo and video data. A folder with this name will be created under the output directory and will contain the final .vbo and video files.</html>";
        label.setToolTipText(toolTipText);
        this.sessionName.setToolTipText(toolTipText);
        southPanel.add((Component)panel, "North");
        panel = new JPanel();
        panel.add(this.syncLock);
        panel.add(this.performIntegration);
        this.performIntegration.setEnabled(false);
        southPanel.add((Component)panel, "Center");
        southPanel.setBorder(BorderFactory.createEtchedBorder());
        return southPanel;
    }

    private void addActionListeners() {
        this.outputDirChoose.addActionListener(this);
        this.performIntegration.addActionListener(this);
        this.syncLock.addActionListener(this);
    }

    private void chooseOutputDirectory() {
        JFileChooser fileChooser = new JFileChooser();
        if (browsePath != null) {
            fileChooser.setCurrentDirectory(new File(browsePath));
        }
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.outputDirPath.setText(fileChooser.getSelectedFile().getAbsolutePath());
            browsePath = this.outputDirPath.getText();
        }
    }

    static String getBrowsePath() {
        return browsePath;
    }

    static void setBrowsePath(String browsePath) {
        VboEditorApplication.browsePath = browsePath;
    }

    private VboEditor.VideoType getVideoType() {
        String videoExtension;
        String videoFilePath = this.synchronizationPanel.getVideoFilePath();
        try {
            videoExtension = videoFilePath.substring(videoFilePath.lastIndexOf(".")).toLowerCase();
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalStateException("Please select a valid video file");
        }
        return switch (videoExtension) {
            case ".mp4" -> VboEditor.VideoType.MP4;
            case ".avi" -> VboEditor.VideoType.AVI;
            default -> throw new RuntimeException(String.format("Video of type %s is not supported", videoExtension));
        };
    }

    private void integrateGpsAndVideo() {
        try {
            this.synchronizationPanel.requestPause();
            final String outputDir = this.outputDirPath.getText();
            final String vboFilePath = this.synchronizationPanel.getTelemetryFilePath();
            final String sessionName = this.sessionName.getText();
            final String videoFilePath = this.synchronizationPanel.getVideoFilePath();
            this.validateInput(outputDir, vboFilePath, sessionName, videoFilePath);
            final VboEditor.VideoType videoType = this.getVideoType();
            final long gpsDataTotalOffsetMillis = this.synchronizationPanel.getTelemetryDataOffset();
            final VboEditorApplication messageDialogParent = this;
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() {
                    try {
                        VboEditor.createVboWithVideoMetadata(outputDir, vboFilePath, videoType, sessionName, (int)gpsDataTotalOffsetMillis);
                        VboEditor.createVideoFile(outputDir, videoFilePath, sessionName);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(messageDialogParent, e.getMessage(), "An error occurred", 0);
                        return null;
                    }
                    JOptionPane.showMessageDialog(messageDialogParent, "Check " + outputDir + "/" + sessionName + " for video and vbo files!", "Done!", 1);
                    return null;
                }

                @Override
                protected void done() {
                    VboEditorApplication.this.hideWaitDlg();
                }
            };
            worker.execute();
            this.showWaitDlg();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "An error occurred", 0);
        }
    }

    private void validateInput(String outputDir, String vboFilePath, String sessionName, String videoFilePath) {
        if (Strings.isNullOrEmpty(vboFilePath)) {
            throw new IllegalStateException("Please select a valid vbo file");
        }
        if (Strings.isNullOrEmpty(videoFilePath)) {
            throw new IllegalStateException("Please select a valid video file");
        }
        File outputDirFile = new File(outputDir);
        if (!outputDirFile.exists() || !outputDirFile.isDirectory()) {
            throw new IllegalStateException("Please select a valid output directory");
        }
        if (Strings.isNullOrEmpty(sessionName)) {
            throw new IllegalStateException("Please select a valid session name");
        }
        File finalPath = new File(outputDir + "/" + sessionName);
        if (!finalPath.exists() && !finalPath.mkdir()) {
            throw new IllegalStateException("Session name should be a valid folder name");
        }
    }

    boolean isDataLocked() {
        return this.syncLock.isSelected();
    }

    void enableDataLock(boolean enable) {
        this.syncLock.setEnabled(enable);
    }

    private JPanel createAboutPanel() {
        String aboutMessage = "<html><h2>Vbo Tools</h2><h2>Version 0.94beta</h2>A toolset for the .vbo telemetry format including:<ul><li>A tool that can help you sync and integrate Telemetry and Video data so you can do video analysis on Circuit Tools.</li><li>A tool to convert between .vbo and .dbn files.</li><li>Maybe more to come!</li></ul><p>Author: George Sikalias (sikrip)</p><p>Contact Info: sikrip@gmail.com, facebook.com/sikrip, twitter @sikrip</p></html>";
        JPanel aboutPanel = new JPanel();
        aboutPanel.add(new JLabel("<html><h2>Vbo Tools</h2><h2>Version 0.94beta</h2>A toolset for the .vbo telemetry format including:<ul><li>A tool that can help you sync and integrate Telemetry and Video data so you can do video analysis on Circuit Tools.</li><li>A tool to convert between .vbo and .dbn files.</li><li>Maybe more to come!</li></ul><p>Author: George Sikalias (sikrip)</p><p>Contact Info: sikrip@gmail.com, facebook.com/sikrip, twitter @sikrip</p></html>"));
        return aboutPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.outputDirChoose) {
            this.chooseOutputDirectory();
        } else if (source == this.performIntegration) {
            this.integrateGpsAndVideo();
        } else if (source == this.syncLock) {
            this.toggleSyncLock();
        }
    }

    private void toggleSyncLock() {
        if (this.syncLock.isSelected()) {
            this.synchronizationPanel.lock();
        } else {
            this.synchronizationPanel.unlock();
        }
        this.synchronizationPanel.requestPause();
        this.performIntegration.setEnabled(this.syncLock.isSelected());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    VboEditorApplication.checkVersion();
                }
                catch (Exception e) {
                    LOGGER.error("Could not get the current version number", e);
                }
                VboEditorApplication editorGui = new VboEditorApplication();
                editorGui.createGui();
                editorGui.addActionListeners();
                editorGui.pack();
                editorGui.setLocationRelativeTo(null);
                editorGui.setResizable(false);
                editorGui.setVisible(true);
                editorGui.setDefaultCloseOperation(3);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkVersion() throws IOException {
        try (Closeable response = null;){
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://www.vbotools.com/version");
            response = httpclient.execute(httpGet);
            HttpEntity entity = response.getEntity();
            String content = EntityUtils.toString(entity);
            int start = content.indexOf("version-start:") + "version-start:".length();
            int end = content.indexOf(":version-end");
            String latestVersionTag = content.substring(start, end).toLowerCase();
            EntityUtils.consume(entity);
            if (!"0.94beta".toLowerCase().equals(latestVersionTag)) {
                JOptionPane.showMessageDialog(null, String.format("New version (%s) is available get it from www.vbotools.com.", latestVersionTag), "Update your version", 1);
            }
        }
    }
}

