/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.gui;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sikrip.vboeditor.engine.VboToDbn;
import org.sikrip.vboeditor.gui.FileConverterPanelSupport;
import org.sikrip.vboeditor.gui.VboEditorApplication;
import org.sikrip.vboeditor.helper.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VboToDbnConverterPanel
extends FileConverterPanelSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VboToDbnConverterPanel.class);

    public VboToDbnConverterPanel(VboEditorApplication editor) {
        super(editor);
    }

    @Override
    String getConvertButtonText() {
        return "Convert to vbo";
    }

    @Override
    void doConvert() {
        try {
            String outputFilePath = this.getOutFileFolderPath() + "/" + new File(this.getInputFilePath()).getName() + ".dbn";
            VboToDbn.convert(this.getInputFilePath(), outputFilePath);
            JOptionPane.showMessageDialog(null, "Dbn file: " + outputFilePath, "Conversion completed.", 1);
        }
        catch (Exception e) {
            ErrorHandler.showError("Could not convert", "Unable to perform vbo to dbn conversion.", e);
            LOGGER.error("Unable to perform vbo to dbn conversion", e);
        }
    }

    @Override
    FileFilter getFileNameExtensionFilter() {
        return new FileNameExtensionFilter(".vbo files", "vbo");
    }

    @Override
    String getTitle() {
        return "Convert from .vbo to .dbn";
    }
}

