/*
 * Decompiled with CFR 0.152.
 */
package org.sikrip.vboeditor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sikrip.vboeditor.gui.SynchronizationPanel;
import org.sikrip.vboeditor.gui.VboEditorApplication;
import org.sikrip.vboeditor.helper.ErrorHandler;
import org.sikrip.vboeditor.helper.TimeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VideoPlayer
extends JPanel
implements ActionListener,
ChangeListener {
    private final Logger LOGGER = LoggerFactory.getLogger(VideoPlayer.class);
    private static final double MAX_DURATION_FETCH_ATTEMPTS = 5.0;
    private final JButton fileChoose = new JButton("...");
    private final JTextField filePath = new JTextField();
    private final SynchronizationPanel synchronizationPanel;
    private MediaPlayer mediaPlayer;
    private final List<InvalidationListener> playListeners = new ArrayList<InvalidationListener>();
    private final JFXPanel videoPanel;
    private final JPanel controlsPanel = new JPanel(new BorderLayout());
    private final JLabel timeLabel = new JLabel();
    private final JSlider seekSlider = new JSlider();
    private final JButton playPause = new JButton("Play");
    private final JButton reset = new JButton("Reset");
    private final JButton prev2 = new JButton("<<");
    private final JButton prev = new JButton("<");
    private final JButton next = new JButton(">");
    private final JButton next2 = new JButton(">>");

    VideoPlayer(SynchronizationPanel synchronizationPanel) {
        this.synchronizationPanel = synchronizationPanel;
        this.setBorder(BorderFactory.createTitledBorder("Video (.avi, .mp4)"));
        this.videoPanel = new JFXPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.videoPanel, "Center");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 2));
        northPanel.add(this.filePath);
        northPanel.add(this.fileChoose);
        this.fileChoose.setToolTipText("Select a video file. Supported video types are .avi and .mp4.");
        this.fileChoose.addActionListener(this);
        this.add((Component)northPanel, "North");
        this.createControlsPanel();
        this.add((Component)this.controlsPanel, "South");
        this.enableControls(false);
    }

    private void createControlsPanel() {
        JPanel panel = new JPanel();
        this.prev2.addActionListener(this);
        panel.add(this.prev2);
        this.prev.addActionListener(this);
        panel.add(this.prev);
        this.playPause.addActionListener(this);
        panel.add(this.playPause);
        this.next.addActionListener(this);
        panel.add(this.next);
        this.next2.addActionListener(this);
        panel.add(this.next2);
        this.reset.addActionListener(this);
        panel.add(this.reset);
        this.prev2.setToolTipText("Two steps back");
        this.prev.setToolTipText("One step back");
        this.next.setToolTipText("One step forward");
        this.next2.setToolTipText("Two steps forward");
        this.reset.setToolTipText("Go to the start");
        this.seekSlider.setValue(0);
        this.seekSlider.addChangeListener(this);
        this.controlsPanel.add((Component)this.timeLabel, "North");
        this.controlsPanel.add((Component)this.seekSlider, "Center");
        this.controlsPanel.add((Component)panel, "South");
    }

    private void loadVideoPanel() {
        try {
            Dimension size = this.getSize();
            File videoFile = new File(this.filePath.getText());
            Media media = new Media(videoFile.toURI().toURL().toString());
            this.mediaPlayer = new MediaPlayer(media);
            MediaView mediaView = new MediaView(this.mediaPlayer);
            Scene scene = new Scene(new Group(mediaView), size.getWidth(), size.getHeight());
            this.videoPanel.setScene(scene);
            mediaView.setFitWidth(scene.getWidth());
            mediaView.setFitHeight(scene.getHeight());
            this.playListeners.add(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    VideoPlayer.this.updateTimeLabel();
                }
            });
            final VideoPlayer seekSliderListener = this;
            this.mediaPlayer.setOnPlaying(new Runnable(){

                @Override
                public void run() {
                    VideoPlayer.this.seekSlider.removeChangeListener(seekSliderListener);
                    VideoPlayer.this.playPause.setText("Pause");
                    VideoPlayer.this.seekSlider.setEnabled(false);
                    VideoPlayer.this.enableFileControls(false);
                    VideoPlayer.this.enableSeekControls(false);
                }
            });
            this.mediaPlayer.setOnPaused(new Runnable(){

                @Override
                public void run() {
                    for (InvalidationListener playListener : VideoPlayer.this.playListeners) {
                        VideoPlayer.this.mediaPlayer.currentTimeProperty().removeListener(playListener);
                    }
                    long currentTime = VideoPlayer.this.getCurrentTime();
                    VideoPlayer.this.synchronizationPanel.seekTelemetryByTime(currentTime);
                    VideoPlayer.this.seekSlider.setValue((int)(currentTime / 1000L));
                    VideoPlayer.this.playPause.setText("Play");
                    VideoPlayer.this.seekSlider.setEnabled(true);
                    VideoPlayer.this.enableFileControls(!VideoPlayer.this.synchronizationPanel.isDataLocked());
                    VideoPlayer.this.enableSeekControls(true);
                    VideoPlayer.this.seekSlider.addChangeListener(seekSliderListener);
                }
            });
            this.timeLabel.setText("Time: " + TimeHelper.getTimeString(0L));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot load video", e);
        }
    }

    private void setupSlider() {
        try {
            Duration duration;
            int durationFetchAttempts = 1;
            do {
                duration = this.mediaPlayer.getMedia().getDuration();
                ++durationFetchAttempts;
                if (!duration.isUnknown()) continue;
                Thread.sleep(100L);
            } while ((double)durationFetchAttempts < 5.0 && duration.isUnknown());
            this.seekSlider.setMinimum(0);
            this.seekSlider.setMaximum((int)duration.toSeconds());
            this.seekSlider.setValue(0);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(0, new JLabel("0"));
            labelTable.put(this.seekSlider.getMaximum(), new JLabel(TimeHelper.getTimeString((long)duration.toMillis())));
            this.seekSlider.setLabelTable(labelTable);
            this.seekSlider.setPaintLabels(true);
        }
        catch (Exception e) {
            this.seekSlider.setVisible(false);
            this.LOGGER.error("Cannot setup slider", e);
        }
    }

    void enableFileControls(boolean b) {
        this.fileChoose.setEnabled(b);
        this.filePath.setEnabled(b);
    }

    private void reset() {
        this.mediaPlayer.stop();
        this.seekSlider.setValue(0);
        this.enableSeekControls(true);
    }

    private void enableSeekControls(boolean enable) {
        this.next.setEnabled(enable);
        this.next2.setEnabled(enable);
        this.prev.setEnabled(enable);
        this.prev2.setEnabled(enable);
        this.seekSlider.setEnabled(enable);
        this.reset.setEnabled(enable);
    }

    private void enableControls(boolean enable) {
        this.enableSeekControls(enable);
        this.reset.setEnabled(enable);
        this.playPause.setEnabled(enable);
    }

    private void loadVideo() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            if (VboEditorApplication.getBrowsePath() != null) {
                fileChooser.setCurrentDirectory(new File(VboEditorApplication.getBrowsePath()));
            }
            fileChooser.setFileFilter(new FileNameExtensionFilter("Video files", "mp4", "avi"));
            if (fileChooser.showOpenDialog(this) == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.filePath.setText(selectedFile.getAbsolutePath());
                this.loadVideoPanel();
                this.setupSlider();
                this.enableControls(true);
                this.synchronizationPanel.checkCanLock();
                VboEditorApplication.setBrowsePath(selectedFile.getParent());
            }
        }
        catch (Exception e) {
            ErrorHandler.showError("Could not load video", "Invalid video file", e);
            this.filePath.setText("");
        }
    }

    private void playPause() {
        MediaPlayer.Status status = this.mediaPlayer.getStatus();
        if (MediaPlayer.Status.PLAYING.equals((Object)status)) {
            this.requestPause();
        } else {
            this.play();
        }
    }

    private void play() {
        for (InvalidationListener playListener : this.playListeners) {
            this.mediaPlayer.currentTimeProperty().addListener(playListener);
        }
        this.mediaPlayer.play();
    }

    void requestPause() {
        if (this.mediaPlayer != null && !MediaPlayer.Status.PAUSED.equals((Object)this.mediaPlayer.getStatus())) {
            this.mediaPlayer.pause();
        }
    }

    String getFilePath() {
        return this.filePath.getText();
    }

    private void step(long durationMillis) {
        if (durationMillis < 0L) {
            this.mediaPlayer.seek(this.mediaPlayer.getCurrentTime().subtract(new Duration(Math.abs(durationMillis))));
        } else {
            this.mediaPlayer.seek(this.mediaPlayer.getCurrentTime().add(new Duration(durationMillis)));
        }
        this.updateTimeLabel();
        this.synchronizationPanel.stepTelemetry(durationMillis);
    }

    private void seek() {
        long newTime = this.seekSlider.getValue() * 1000;
        this.mediaPlayer.seek(new Duration(newTime));
        this.updateTimeLabel();
        this.synchronizationPanel.seekTelemetryByTime(newTime);
    }

    boolean isLoaded() {
        return !this.filePath.getText().isEmpty();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.playPause) {
            this.playPause();
        } else if (source == this.reset) {
            this.reset();
        } else if (source == this.next) {
            this.step(50L);
        } else if (source == this.next2) {
            this.step(100L);
        } else if (source == this.prev) {
            this.step(-50L);
        } else if (source == this.prev2) {
            this.step(-100L);
        } else if (source == this.fileChoose) {
            this.loadVideo();
        }
    }

    private void updateTimeLabel() {
        long currentTime = this.getCurrentTime();
        this.timeLabel.setText("Time: " + TimeHelper.getTimeString(currentTime));
        this.seekSlider.setValue((int)(currentTime / 1000L));
    }

    long getCurrentTime() {
        if (this.mediaPlayer == null) {
            return 0L;
        }
        return (long)(this.mediaPlayer.getCurrentTime().toMillis() * 1000.0 / 1000.0);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.mediaPlayer != null) {
            this.seek();
        }
    }

    void addPlayListener(InvalidationListener listener) {
        this.playListeners.add(listener);
    }

    void removePlayListener(InvalidationListener listener) {
        this.playListeners.remove(listener);
    }
}

